<?
class Validation
{
/*
Usage: 
alphanum, alpha, alphanospace, num, dec, email, url
$val = new Validation();
$val->addRule($value,'num','Field 1', true, false, false );
*/
	var $error = array();
	
	//field name, type, req, min, max, error msg//
	function addRule($field, $type, $label, $req=false, $min=false, $max=false)
	{
		if($req==true and trim($field) =='' )
		{
			//$this->error[] = 'Please Enter '.$label.'.';
			$this->error[] = $label.' is required.';
			return false;
		}		
		
		if($min)
		{
			if(strlen($field)<$min)
			{
				$this->error[] = "Minimum $min characters required in $label";
				return false;
			}
		}
		
		if($max)
		{
			if(strlen($field)>$max)
			{
				$this->error[] = "Maximum $max characters allowed in $label";
				return false;
			}
		}
		
		if($type=='alphanum')
		{
			$result = ereg ("^[A-Za-z0-9\ ]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter valid characters in $label";
				return false;
			}		
		}elseif($type=='alphanumnospace')
		{
			$result = ereg ("^[A-Za-z0-9\.]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter alphabets without space in $label";
				return false;
			}		
		}
		elseif($type=='alpha')
		{
			$result = ereg ("^[A-Za-z\ ]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter alphabets in $label";
				return false;
			}		
		}
		elseif($type=='alphanospace')
		{
			$result = ereg ("^[A-Za-z\]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter alphabets without space in $label";
				return false;
			}		
		}
		elseif($type=='num')
		{
			$result = ereg ("^[0-9\ ]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter numbers in $label";
				return false;
			}		
		}
		elseif($type=='dec')
		{
			$result = ereg ("^[0-9\.]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter numbers in $label";
				return false;
			}		
		}
		elseif($type=='email')
		{
			$result = ereg ("^[^@ ]+@[^@ ]+\.[^@ \.]+$", $field);
			if (!$result)
			{
				$this->error[] = "Please enter valid email address.";
				return false;
			}
		}
		elseif($type=='pass')
		{
			$passPatern="/^(?=.*\d)([a-zA-Z0-9]){4,5}+([0-9]){1}$/";
			
			if(preg_match($passPatern,$field)==0)			
			{
				$this->error[]= "Passwords should be at least 5 characters long and include 1 number. Please try again.";
				return false;
			}
		}
		elseif($type=='url')
		{
			$result = preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $field);
			if (!$result)
			{
				$this->error[] = "Please enter valid url.";
				return false;
			}
		}
		
	}
	/*validate() return true or flase for error*/
	function validate()
	{
		
		if(!count($this->error))
		{
			/*$stat = '';
			foreach($this->error as $k => $val)
			{
				$stat.=$val.'<br />';
			}*/
			return true;		
		}
		else
		{
			return false;
		}
	
	}
	/* errors() is used for return error once at a time*/
	function errors()
	{
		return $this->error[0];		
	}
	/* confirmPassword($field1,$field2) is used for password and confirm password both same or not*/
	function confirmPassword($field1,$field2)
	{
		if($field1!=$field2)	
		{
			$this->error[] = "Confirm password not matching";
			return false;
		}
	}	
	/* verifyuser is used for check user is allredy exits or not */
	function verifyuser($val,$field,$table,$msg)
	{
		
		$dbUser=getvalue($field,$table,"where $field='$val'");		
		if($dbUser==$val)
		{
			$this->error[] =$msg;
			return false;
		}
	
	}
	/*verifycaptcha is used for match the captcha code*/
	function verifycaptcha($code1,$code2)
	{
		if($code1!=$code2)
		{
			$this->error[] = "Please enter valid verification code";
			return false;
		}
	}
	/*message function return simply a given message*/
	function message($msg)
	{
		
		return $msg;
	
	}
	/*validiate_user($email,$password,$table,$customer_type) 
	This function check user and set user Log In session, by using email and pass.*/
	function validiate_user($email,$password)
	{
		$dbUser=getvalue('email',"customers","where email='$email' and password='$password'");		
		if($dbUser==$email)
		{
/*			$_SESSION['customer']['name']=getvalue('email',$table,"where email='$email' and password='$password'");
			$_SESSION['customer']['type']=getvalue('customer_type',$table,"where email='$email' and password='$password'");*/
			$this->error[] = "Valid Login Details";
			return TRUE;
		}
		else
		{
			$this->error[] = "Invalid e-mail address or password";
			return FALSE; 
		}
	}
}
?>