<?php
include("../db.php");
header('Content-Type: application/json');

$status = 0;
$data = array();
$msg = "Unable to process request";

// Open connection
$ch = curl_init();

$running = 0;
$stopped = 0;
$idle = 0;
$inactive = 0;
$no_data = 0;

$total = 0;

$running_vehicle_list  = array();
$stopped_vehicle_list  = array();
$idle_vehicle_list     = array();
$inactive_vehicle_list = array();
$no_data_vehicle_list  = array();

$result = get_live_location_hitecpoint($ch);

if (is_array($result) && count($result) > 0) {

    foreach ($result as $live_location){

        if (is_array($live_location) && count($live_location) > 0){

            $status = 1;
            $msg = "Request successful";

            $vehicle_status = "";
            if ($live_location['VehicleStatus'] == 'Running'){$vehicle_status = "RUNNING";}elseif ($live_location['VehicleStatus'] == 'Stopped'){$vehicle_status = "STOP";}

            $vehicle_data = array("Status" => $vehicle_status, "Vehicle_No" => $live_location["VehName"], "Datetime" => $live_location["Lastdate"], "Location" => $live_location["Location"],
                                  "AC" => $live_location["ACStatus"], "Latitude" => $live_location["Latitude"], "Longitude" => $live_location["Longitude"],
                                  "Driver_First_Name" => "--", "Vehicle_Name" => "NA", "IGN" => "NA", "Power" => "NA", "GPS" => "NA", "Odometer" => 0, "Speed" => 0);

            if ($live_location['VehicleStatus'] == 'Running'){
                $running = $running + 1;
                $running_vehicle_list[] = $vehicle_data;
            }elseif ($live_location['VehicleStatus'] == 'Stopped'){
                $stopped = $stopped+1;
                $stopped_vehicle_list[] = $vehicle_data;
            }else{
                $idle = $idle+1;
                $idle_vehicle_list[] = $vehicle_data;
            }
        }else{
            $msg = 'Data not found or time limit exceeded...! Please try again later.';
        }

    }

}else{
    $msg = "Data not found...!";
}

$total = $running + $stopped + $idle + $inactive + $no_data;

echo json_encode(array('status' => $status, 'data' => array(
    array('count' => $running, 'text' => 'Running : '.$running, 'vehicle_list' => $running_vehicle_list),
    array('count' => $stopped, 'text' => 'Stop : '.$stopped, 'vehicle_list' => $stopped_vehicle_list),
    array('count' => $idle, 'text' => 'Idle : '.$idle, 'vehicle_list' => $idle_vehicle_list),
    array('count' => $inactive, 'text' => 'Inactive : '.$inactive, 'vehicle_list' => $inactive_vehicle_list),
    array('count' => $no_data, 'text' => 'No Data : '.$no_data, 'vehicle_list' => $no_data_vehicle_list),
), 'total' => $total, 'message' => $msg));



// Close connection
curl_close($ch);



function get_live_location_hitecpoint($curl_object)
{
    $json_res = array();

    $url = "http://htp2.hitecpoint.in/api/Pgm/live/?apiKey=419C294F-6B0C-40D7-9FA2-277453AC63F3";

    // Set the url, number of POST vars, POST data
    curl_setopt($curl_object, CURLOPT_URL, $url);
    curl_setopt($curl_object, CURLOPT_RETURNTRANSFER, true);

    // Execute post
    $result = curl_exec($curl_object);

    if (!empty($result)) {
        $json_res = json_decode($result, true);
    }
    return $json_res;
}