<?php date_default_timezone_set('Asia/Kolkata'); ?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.css" integrity="sha256-uXf0U0UCIqBp2J3S53b28h+fpC9uFcA8f+b/NNmiwVk=" crossorigin="anonymous" />
    <title>Manage</title>

  </head>
  <body>
    <div class="container-fluid">
        <div class="row">

            <?php include('sidebar.php'); ?>
            
            <div class="col-md-10">
                
                <div style="box-shadow:0px 0px 8px #555;margin:20px;padding:20px;border-radius:5px;min-height:600px;">
                    
                    <h2 class="bg-dark text-white text-center p-2">MANAGE</h2>
                    
                    <form method="post" id="myForm" action="">
                        <div id="editform">
                        <input type="hidden" name="type" value="manage" />
                    
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Teachers List</label>
                              <select class="form-control" name="teacher" required id="teacherlist">
                                    <option value="">--Select Teacher--</option>
                                  <?php $allteachers = $db->getRows("select * from staff where channel_id!='' and session='".$_SESSION['admin']['session']."' ");
                                      foreach($allteachers as $teacher){
                                          ?>
                                        <option value="<?php echo $teacher[idno]; ?>"><?php echo $teacher[name]; ?></option>
                                <?php
                                      }
                                  ?>
                              </select>
                        </div>
    
                        <div class="col-md-6 form-group">
                            <label>Date</label>
                            <input type="date" name="date" class="form-control"  value="<?php echo date('Y-m-d'); ?>">
                        </div>
                        
                    </div>

                      <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Time</label>
                            <input type="time" name="time" class="form-control"  value="<?php echo date('H:i'); ?>">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Class</label>
                          <select class="form-control" name="class" required>
                                <option value="">--Select Class--</option>
                                <option value="allclass">All Classes</option>
                              <?php $allclasses = $db->getRows("select * from class");
                                  foreach($allclasses as $class){
                                      ?>
                                    <option value="<?php echo $class['class']; ?>"><?php echo $class['class']; ?></option>
                            <?php
                                  }
                              ?> 
                          </select>
                        </div>
                      </div>
                      
                      <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Chapter</label>
                            <input type="text" name="chapter" class="form-control"  placeholder="">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Topic</label>
                            <input type="text" name="topic" class="form-control"  placeholder="">
                        </div>
                      </div>

                      <div class="form-group row">
                        <div class="col-md-6 offset-3">
                          <input type="submit" class="form-control btn btn-success" value="SAVE" >
                        </div>
                      </div>
                      
                    </div>  
                    </form>
                    

                <br><br>
                <h4 class="bg-info text-white text-center p-1">LIVE UPCOMING CLASSES LIST</h4>
                    <div class="row">
                        <div class="col-md-2">
                            <label style="font-weight:bold;">Filter Record</label>         
                        </div>
                        <div class="col-md-4">
                          <select class="form-control" name="teacher" onchange="filter_upcomingclass(this.value)" required id="teacherlist">
                                <option value="">--Select Teacher--</option>
                              <?php $allteachers = $db->getRows("select * from staff where channel_id!='' and session='".$_SESSION['admin']['session']."' ");
                                  foreach($allteachers as $teacher){
                                      ?>
                                    <option value="<?php echo $teacher[idno]; ?>"><?php echo $teacher[name]; ?></option>
                            <?php
                                  }
                              ?>
                          </select>                            
                        </div>
                    </div><br>
                
                <div id="upcomingclassrecord">

                <table class="table table-sm table-striped table-hover">
                    <tr>
                        <th>S.No.</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Teacher Name</th>
                        <th>Class</th>
                        <th>Chapter</th>
                        <th>Topic</th>
                        <th>Action</th>
                    </tr>
                    <?php $allteachers = $db->getRows("select * from staff where channel_id!='' and session='".$_SESSION['admin']['session']."' ");

                                $current_date = date('Y-m-d');
                                $current_time = date('H:i');
                            foreach($allteachers as $teacher){

                                $upcomingclass = $db->getRows("select * from live_upcoming_class where teacher='$teacher[idno]' and date >= '$current_date' order by date DESC ");

                                foreach($upcomingclass as $class){ $i++;
                                $date=date_create($class[date]);
                                $date = date_format($date,"d-m-Y");
                                    ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td><?php echo $date; ?></td>
                                        <td><?php echo $class[time]; ?></td>
                                        <td><?php echo $teacher[name]; ?></td>
                                        <td><?php echo $class['class']; ?></td>
                                        <td><?php echo $class[chapter]; ?></td>
                                        <td><?php echo $class[topic];?></td>
                                        <td>
                                            <a onclick="edit(<?php echo $class[id]; ?>)"><img src="edit.jpg" style="width:20px;height:20px;cursor:pointer;" title="Edit" /></a>&ensp;
                                            <a onclick="delete_upcomingclass(<?php echo $class[id]; ?>)"><img src="delete.png" style="width:20px;height:20px;cursor:pointer;" title="Delete"/></a>
                                        </td>
                                    </tr>
                                    <?php
                                }

                        }
                    ?>

                </table>
                </div>

                </div>

            </div>

        </div>
    </div>

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js" integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(function(){
       $("#myForm").submit(function(event){
           event.preventDefault();
           $.ajax({
               method: 'POST',
               url: 'ajax.php',
               data : $('#myForm').serialize(),
               success: function( response ){

            filter_upcomingclass();

                        Swal.fire({
                          position: 'top-end',
                          icon: 'success',
                          title: 'Data saved successfully',
                          showConfirmButton: false,
                          timer: 2000
                        }),
                        $( '#myForm' ).each(function(){
                            this.reset();
                        });

               },
               error: function(xhr, desc, err){
                        Swal.fire({
                          position: 'top-end',
                          icon: 'error',
                          title: 'something went wrong. Please try again',
                          showConfirmButton: false,
                          timer: 2000
                        })
               }
           });
       });
    });
    

    
});

function edit(id){
    $.post("ajax.php", { type: "editclass" , id: id } , function( data ) {
        document.documentElement.scrollTop = 0;
        document.getElementById('editform').innerHTML = data;
    });
}

function delete_upcomingclass(id){
    var r = confirm("Are you sure want to delete?");
  if (r == true) {
    $.post("ajax.php", { type: "delete_upcomingclass" , id: id } , function( data ) {
        filter_upcomingclass();
        
                        Swal.fire({
                          position: 'top-end',
                          icon: 'success',
                          title: 'Record Deleted successfully.',
                          showConfirmButton: false,
                          timer: 1500
                        });
        
    });
  }
}

function filter_upcomingclass(id){
    $.post("ajax.php", { type: "filter_upcomingclass" , id: id } , function( data ) {
      document.getElementById('upcomingclassrecord').innerHTML = data;
    });
}

</script>

  </body>
</html>